<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('user_skills', function (Blueprint $table) {
            $table->unsignedBigInteger('Skill_id')->autoIncrement();
            $table->unsignedBigInteger('User_id');
            $table->string('Skill_name', 100);
            $table->enum('Proficiency_level', ['beginner', 'intermediate', 'advanced', 'expert'])->default('intermediate');
            $table->boolean('Verified')->default(0);
            $table->unsignedBigInteger('Verified_by')->nullable();
            $table->timestamp('Verified_at')->nullable();
            $table->timestamp('Created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('Updated_at')->default(DB::raw('CURRENT_TIMESTAMP'))->onUpdate(DB::raw('CURRENT_TIMESTAMP'));
            $table->foreign('User_id', 'user_skills_user_id_foreign')->references('User_id')->on('users')->onDelete('cascade');
            $table->foreign('Verified_by', 'user_skills_verified_by_foreign')->references('User_id')->on('users')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_skills');
    }
};
